clc;clear 
addpath('..\Functions\');

load PITs_macro

%switch here to chose data to be analyzed
%data=data_np2;

model=1;   %set =1 for Gaussian case and to anything else for nonparametric case

%the forecasting horizon
for h=1:4
    disp(['Forecast horizon: ', num2str(h)]);
    lags=h-1;
    if model == 1
        name=['data_norm',num2str(h)];
        data=eval(name);
    else
        name=['data_np',num2str(h)];
        data=eval(name);
    end

    U1=data(:,11);
    U2=data(:,12);
    U3=data(:,13);

    U12=data(:,5);
    U13=data(:,6);
    U21=data(:,7);
    U23=data(:,8);
    U31=data(:,9);
    U32=data(:,10);

    U123=data(:,2);
    U213=data(:,3);
    U312=data(:,4);

    % Tests on all individual PITs
    NST=zeros(12,1);
    for i=2:13
        [NST(i-1)]=NST_DM(data(:,i),lags);
    end

    Uni=[NST]

    % The chi2 statistics for all six permutations
    NST=zeros(6,1);

    U_Z2=chi2cdf(norminv(U1).^2+norminv(U21).^2+norminv(U312).^2,3);U_Z2(U_Z2==1)=0.999999;
    [NST(1)]=NST_DM(U_Z2,lags);

    U_Z2=chi2cdf(norminv(U1).^2+norminv(U31).^2+norminv(U213).^2,3);U_Z2(U_Z2==1)=0.999999;
    [NST(2)]=NST_DM(U_Z2,lags);

    U_Z2=chi2cdf(norminv(U2).^2+norminv(U12).^2+norminv(U312).^2,3);U_Z2(U_Z2==1)=0.999999;
    [NST(3)]=NST_DM(U_Z2,lags);

    U_Z2=chi2cdf(norminv(U2).^2+norminv(U32).^2+norminv(U123).^2,3);U_Z2(U_Z2==1)=0.999999;
    [NST(4)]=NST_DM(U_Z2,lags);

    U_Z2=chi2cdf(norminv(U3).^2+norminv(U23).^2+norminv(U123).^2,3);U_Z2(U_Z2==1)=0.999999;
    [NST(5)]=NST_DM(U_Z2,lags);

    U_Z2=chi2cdf(norminv(U3).^2+norminv(U13).^2+norminv(U213).^2,3);U_Z2(U_Z2==1)=0.999999;
    [NST(6)]=NST_DM(U_Z2,lags);

    Z2=[NST];


    % The DHT statistics for all six permutations
    NST=zeros(6,1);

    U=[U1' U21' U312']';U(U==1)=0.999999;
    [NST(1)]=NST_DM(U,lags);

    U=[U1' U31' U213']';U(U==1)=0.999999;
    [NST(2)]=NST_DM(U,lags);

    U=[U2' U12' U312']';U(U==1)=0.999999;
    [NST(3)]=NST_DM(U,lags);

    U=[U2' U32' U123']';U(U==1)=0.999999;
    [NST(4)]=NST_DM(U,lags);

    U=[U3' U23' U123']';U(U==1)=0.999999;
    [NST(5)]=NST_DM(U,lags);

    U=[U3' U13' U213']';U(U==1)=0.999999;
    [NST(6)]=NST_DM(U,lags);

    DHT=[NST];



    % The CS statistics for all six permutations
    NST=zeros(6,1);

    U=U1.*U21.*U312;
    U=CS_PIT(U,3);
    [NST(1)]=NST_DM(U,lags);

    U=U1.*U31.*U213;
    U=CS_PIT(U,3);
    [NST(2)]=NST_DM(U,lags);

    U=U2.*U12.*U312;
    U=CS_PIT(U,3);
    [NST(3)]=NST_DM(U,lags);

    U=U2.*U32.*U123;
    U=CS_PIT(U,3);
    [NST(4)]=NST_DM(U,lags);

    U=U3.*U23.*U123;
    U=CS_PIT(U,3);
    [NST(5)]=NST_DM(U,lags);

    U=U3.*U13.*U213;
    U=CS_PIT(U,3);
    [NST(6)]=NST_DM(U,lags);

    CS=[NST];


    % The KP statistics for all six permutations
    NST=zeros(6,1);

    U=(U1-0.5).*(U21-0.5).*(U312-0.5);
    U=KP_PIT(U,3);
    [NST(1)]=NST_DM(U,lags);

    U=(U1-0.5).*(U31-0.5).*(U213-0.5);
    U=KP_PIT(U,3);
    [NST(2)]=NST_DM(U,lags);

    U=(U2-0.5).*(U12-0.5).*(U312-0.5);
    U=KP_PIT(U,3);
    [NST(3)]=NST_DM(U,lags);

    U=(U2-0.5).*(U32-0.5).*(U123-0.5);
    U=KP_PIT(U,3);
    [NST(4)]=NST_DM(U,lags);

    U=(U3-0.5).*(U23-0.5).*(U123-0.5);
    U=KP_PIT(U,3);
    [NST(5)]=NST_DM(U,lags);

    U=(U3-0.5).*(U13-0.5).*(U213-0.5);
    U=KP_PIT(U,3);
    [NST(6)]=NST_DM(U,lags);

    KP=[NST];
    out = [DHT CS KP Z2]


    % The order invariant statistics (Z2): Gaussian case
    if model==1
        Z2_star = norminv(U1).^2+norminv(U2).^2+norminv(U3).^2+norminv(U12).^2+norminv(U13).^2+norminv(U21).^2+norminv(U23).^2 ...
            +norminv(U31).^2+norminv(U32).^2+norminv(U123).^2+norminv(U213).^2+norminv(U312).^2;

        U_Z2_star=zeros(141,1);
        d=3;
        K=d*2^(d-1);
        Index=cell(K,1);
        k=1;
        for i=1:d
            Index{k}=i;
            k=k+1;
            for j=2:d
                ind=nchoosek([1:i-1 i+1:d],j-1);   % all possible conditioning sets of size j-1
                for jj=1:size(ind,1)
                    Index{k}=[i ind(jj,:)];
                    k=k+1;
                end
            end
        end

        for jj=1:141
	    % Import Covariance matrices
            filename=['.\Covars\VCV_h',num2str(h),'_',num2str(jj),'.txt'];
            Sigma=importdata(filename);

            % Create Omega matrix
            Omega=zeros(K,K);
            for i=1:K
                Sigma_ii=Sigma(Index{i}(1),Index{i}(1));
                Sigma_ij=Sigma(Index{i}(1),Index{i}(2:end));
                Sigma_jj=Sigma(Index{i}(2:end),Index{i}(2:end));    

                Omega(i,i)=Sigma_ii-Sigma_ij*inv(Sigma_jj)*Sigma_ij';  % Variance of the transformed variable

                for p=i+1:K
                    Sigma_ip=Sigma(Index{i}(1),Index{p}(1));
                    Sigma_pq=Sigma(Index{p}(1),Index{p}(2:end));
                    Sigma_qq=Sigma(Index{p}(2:end),Index{p}(2:end));
                    Sigma_iq=Sigma(Index{i}(1),Index{p}(2:end));
                    Sigma_jq=Sigma(Index{i}(2:end),Index{p}(2:end));
                    Sigma_pj=Sigma(Index{p}(1),Index{i}(2:end));

                    Omega(i,p)=Sigma_ip-Sigma_pq*inv(Sigma_qq)*Sigma_iq'-Sigma_ij*inv(Sigma_jj)*Sigma_pj'...
                        +Sigma_ij*inv(Sigma_jj)*Sigma_jq*(inv(Sigma_qq)')*(Sigma_pq'); 

                    Omega(p,i)=Omega(i,p); % Symmetric matrix 
                end
            end 
            % Extract corresponding correlation matrix 
            D=diag(sqrt(diag(Omega)));
            R=inv(D)*Omega*inv(D);

            U_Z2_star(jj)=PIT_chi2_mix(Z2_star(jj), R); % Compute PIT of transformed variable
        end

        [MD2] = NST_DM(U_Z2_star,lags);
    else
        % Nonparametric case

        Z2_star = norminv(U1).^2+norminv(U2).^2+norminv(U3).^2+norminv(U12).^2+norminv(U13).^2+norminv(U21).^2+norminv(U23).^2 ...
            +norminv(U31).^2+norminv(U32).^2+norminv(U123).^2+norminv(U213).^2+norminv(U312).^2;
        U_Z2_star = zeros(141,1);
        for jj=1:141
	    % Load simulated distribution of PITs under H0
            filename=['.\SimPITs\SimPITs_h',num2str(h),'_',num2str(jj),'.txt'];
            U_temp=importdata(filename);

            Z2_star_temp=sum(norminv(U_temp').^2)';
            U_Z2_star(jj)=mean(Z2_star(jj)<Z2_star_temp);
        end

        [MD2] = NST_DM(U_Z2_star,lags);
    end


    % Now: Z2_dagger statistics 
    Z2_dag=norminv(U123).^2+norminv(U213).^2+norminv(U312).^2;
    U_Z2_dag=zeros(141,1);

    % Gaussian case
    if model==1
        for jj=1:141
	    % Load covariance matrices
            filename=['.\Covars\VCV_h',num2str(h),'_',num2str(jj),'.txt'];
            Sigma=importdata(filename);    
            Omega=zeros(d,d); % Initiate the covariance matrix of the transformed variables  
            for i=1:d
                Sigma_ii=Sigma(i,i);
                Sigma_ij=[Sigma(i,1:i-1) Sigma(i,i+1:end)];
                Sigma_jj=Sigma;
                Sigma_jj(i,:)=[];
                Sigma_jj(:,i)=[];
                Omega(i,i)= Sigma_ii-Sigma_ij*inv(Sigma_jj)*Sigma_ij';  % Variance of the transformed variable

            for p=i+1:d   %make the covariance between the transformed variables
                Sigma_ip=Sigma(i,p);
                Sigma_pq=[Sigma(p,1:p-1) Sigma(p,p+1:end)];
                Sigma_qq=Sigma;
                Sigma_qq(p,:)=[];
                Sigma_qq(:,p)=[];
                Sigma_iq=[Sigma(i,1:p-1) Sigma(i,p+1:end)];
                Sigma_jq=Sigma;
                Sigma_jq(i,:)=[];
                Sigma_jq(:,p)=[];
                Sigma_pj=[Sigma(p,1:i-1) Sigma(p,i+1:end)];

                Omega(i,p)=Sigma_ip-Sigma_pq*inv(Sigma_qq)*Sigma_iq'-Sigma_ij*inv(Sigma_jj)*Sigma_pj'+Sigma_ij*inv(Sigma_jj)*Sigma_jq*(inv(Sigma_qq)')*(Sigma_pq');
                Omega(p,i)=Omega(i,p); % Symmetric matrix
            end
            end
                
	    % Compute the corresponding correlation matrix 
            D=diag(sqrt(diag(Omega)));
            R=inv(D)*Omega*inv(D);

            U_Z2_dag(jj) = PIT_chi2_mix(Z2_dag(jj), R); % Compute the PITs for transformed variable
        end

        [MD3] = NST_DM(U_Z2_dag,lags);  
    else
	% Non-parametric case
        for jj=1:141
	    % Load simulated distribution of PITs under H0
            filename=['.\SimPITs\SimPITs_h',num2str(h),'_',num2str(jj),'.txt'];
            U_temp=importdata(filename);
            Z2_dag_temp=sum(norminv(U_temp(:,1:3)').^2)';
            U_Z2_dag(jj)=mean(Z2_dag(jj)<Z2_dag_temp);
        end

        [MD3] = NST_DM(U_Z2_dag,lags);    
    end

    % Collect test statistics based on Z2star and Z2_dagger
    [MD2; MD3]

end
